-- mdulo prstamos

create table tipo_archivo(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_archivo primary key(id),
constraint uq_tipo_archivo_nombre unique(nombre)
);

create table estado(
id int not null,
nombre character varying(100) not null,
constraint pk_estado primary key(id),
constraint uq_estado_nombre unique(nombre)
);

create table destino(
id int not null,
nombre character varying(100) not null,
constraint pk_destino primary key(id),
constraint uq_destino_nombre unique(nombre)
);

create table tipo_garantia(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_garantia primary key(id),
constraint uq_tipo_garantia_nombre unique(nombre)
);

create table tipo_plazo(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_plazo primary key(id),
constraint uq_tipo_plazo_nombre unique(nombre)
);

create table archivo_solicitud(
id int not null,
archivo_id int not null,
solicitud_id int not null,
constraint pk_archivo_solicitud primary key(id),
constraint fk_archivo_solicitud_archivo_id foreign key(archivo_id) references archivo(id),
constraint fk_archivo_solicitud_solicitud_id foreign key(solicitud_id) references solicitud(id)
);

create table archivo(
id int not null,
fecha_subida date not null,
tipo_archivo_id int not null,
ruta character varying(200) not null,
nombre_archivo character varying(100) not null,
tipo_extension character varying(30) not null,
solicitud_id int,
constraint pk_archivo primary key(id),
constraint fk_archivo_tipo_archivo_id foreign key(tipo_archivo_id) references tipo_archivo(id),
constraint fk_archivo_solicitud_id foreign key(solicitud_id) references solicitud(id)
);

create table cuenta(
id int not null,
socio_id int not null, --titular de cuenta
fecha_apertura date not null,
fecha_expiracion date,
solicitud_id int,
saldo numeric,
saldo_promedio numeric,
saldo_contable numeric,
saldo_bloqueado numeric,
saldo_retenido numeric,
dias_atraso int,
maximo_atraso int,
monto_atraso numeric,
motivo_cancelacion character varying(100) not null,
fecha_cancelacion date,
fecha_ultimo_movimiento date,
estado_cuenta_id int not null,
tipo_cuenta_id int not null,
constraint pk_cuenta primary key(id),
constraint fk_cuenta_socio_id foreign key(socio_id) references socio(id),
constraint fk_cuenta_solicitud_id foreign key(solicitud_id) references solicitud(id),
constraint fk_cuenta_estado_cuenta_id foreign key(estado_cuenta_id) references estado_cuenta(id),
constraint fk_cuenta_tipo_cuenta_id foreign key(tipo_cuenta_id) references tipo_cuenta(id)
);

create table cuenta_socio(
id int not null,
persona_id int not null,
cuenta_id int not null,
es_titular boolean not null,
constraint pk_cuenta_socio primary key(id),
constraint fk_cuenta_estado_persona_id foreign key(persona_id) references persona(id),
constraint fk_cuenta_estado_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table perfil_economico(
id int not null,
fecha date not null,
persona_id int not null,
inmueble_id int not null,
rodado_id int not null,
cuentas_externas_id int not null,
otros_bienes_id int not null,
deudas_externas_id int not null,
deudas_hipotecarias_id int not null,
renta_mensual_id int not null,
constraint pk_perfil_economico primary key(id),
constraint fk_perfil_economico_persona_id foreign key(persona_id) references persona(id),
constraint fk_perfil_economico_inmueble_id foreign key(inmueble_id) references inmueble(id),
constraint fk_perfil_economico_rodado_id foreign key(rodado_id) references rodado(id),
constraint fk_perfil_economico_cuentas_externas_id foreign key(cuentas_externas_id) references cuentas_externas(id),
constraint fk_perfil_economico_otros_bienes_id foreign key(otros_bienes_id) references otros_bienes(id),
constraint fk_perfil_economico_deudas_externas_id foreign key(deudas_externas_id) references deudas_externas(id),
constraint fk_perfil_economico_deudas_hipotecarias_id foreign key(deudas_hipotecarias_id) references deudas_hipotecarias(id),
constraint fk_perfil_economico_renta_mensual_id foreign key(renta_mensual_id) references renta_mensual(id)
);

-- individual, intercooperativo, empleados
create table tipo_sujeto_credito(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_sujeto_credito primary key(id),
constraint uq_tipo_sujeto_credito_nombre unique(nombre)
);

-- normal, tarjeta crdito, vivienda
create table tipo_credito(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_credito primary key(id),
constraint uq_tipo_credito_nombre unique(nombre)
);

create table tipo_credito(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_credito primary key(id),
constraint uq_tipo_credito_nombre unique(nombre)
);

create table calificacion_socio(
id int not null,
socio_id int not null,
fecha date not null,
calificacion character varying(10) not null,
constraint pk_calificacion_socio primary key(id),
constraint fk_calificacion_socio_socio_id foreign key(socio_id) references socio(id)
);

create table solicitud_prorroga(
id int not null,
cuota_id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_prorroga primary key(id),
constraint fk_solicitud_prorroga_cuota_id foreign key(cuota_id) references cuota(id),
constraint fk_solicitud_prorroga_estado_id foreign key(estado_id) references estado(id)
);

create table solicitud_amplicacion(
id int not null,
prestamo_id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_amplicacion primary key(id),
constraint fk_solicitud_amplicacion_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_solicitud_amplicacion_estado_id foreign key(estado_id) references estado(id)
);

create table solicitud_refinanciacion(
id int not null,
prestamo_id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_amplicacion primary key(id),
constraint fk_solicitud_prorroga_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_solicitud_prorroga_estado_id foreign key(estado_id) references estado(id)
);

create table solicitud_consolidacion(
id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_amplicacion primary key(id),
constraint fk_solicitud_prorroga_estado_id foreign key(estado_id) references estado(id)
);

create table prestamo_consolidacion(
id int not null,
prestamo_id int not null,
solicitud_id int not null,
constraint pk_prestamo_consolidacion primary key(id),
constraint fk_prestamo_consolidacion_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_prestamo_consolidacion_solicitud_id foreign key(solicitud_id) references solicitud_consolidacion(id)
);

create table solicitud_prestamo(
id int not null,
socio_id int not null,
fecha_solicitud date not null,
nro_solicitud character varying(20) not null,
monto_solicitado numeric not null,
cant_cuotas int not null, 
observacion character varying(200),
perfil_economico_id int not null,
destino_id int not null,
tipo_credito_id int not null,
tipo_garantia_id int not null,
tipo_plazo_id int not null,
producto_credito_id int not null,
constraint pk_solicitud primary key(id),
constraint fk_solicitud_persona_id foreign key(persona_id) references persona(id)
);

create table analisis_credito(
id int not null,
solicitud_prestamo_id int not null,
analizado_por int not null, 
fecha_analisis date,
recomendacion_analista character varying(100),
jefe_por int not null, 
fecha_analisis_jefe date,
recomendacion_jefe character varying(100),
gerente_por int not null,
fecha_analisis_gerente date,
recomendacion_gerente character varying(100),
comite_por int not null, 
fecha_analisis_comite date,
recomendacion_comite character varying(100),
consejo_por int not null, 
fecha_analisis_consejo date,
recomendacion_consejo character varying(100),
estado_id int not null,
fecha_estado date not null,
constraint pk_analisis_credito primary key(id)
-- falta agregar los fks
);

create table prestamo(
id int not null,
cuenta_id int not null,
fecha_aprobacion date not null,
saldo numeric,
saldo_capital numeric,
saldo_interes numeric,
capital_pagado numeric,
interes_pagado numeric,
prevision numeric,
prevision_heredada numeric,
cantidad_cuotas int, 
monto_aprobado numeric, 
cantidad_cuotas_pagadas int,
producto_credito_id int not null,
constraint pk_prestamo primary key(id),
constraint fk_prestamo_cuenta_id foreign key(cuenta_id) references cuenta(id),
-- falta agregar los mismo
);

create table codeudor(
id int not null,
persona_id int not null,
prestamo_id int not null,
es_socio boolean not null,
es_conyuge boolean not null,
constraint pk_deudor primary key(id),
constraint fk_deudor_persona_id foreign key(persona_id) references persona(id),
constraint fk_deudor_prestamo_id foreign key(prestamo_id) references prestamo(id)
);

create table tipo_accion(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_accion primary key(id),
constraint uq_tipo_accion_nombre unique(nombre)
);

create table recuperacion(
id int not null,
prestamo_id int not null,
etapa int not null,
tipo_accion_id int not null,
tratamiento character varying(200) not null,
constraint pk_tipo_archivo primary key(id),
constraint fk_recuperacion_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_recuperacion_tipo_accion_id foreign key(tipo_accion_id) references tipo_accion(id)
);

-- cheque, deposito ahorro
create table tipo_desembolso(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_desembolso primary key(id),
constraint uq_tipo_desembolso_nombre unique(nombre)
);

create table descuento_desembolso(
id int not null,
nombre character varying(100) not null,
constraint pk_descuento_desembolso primary key(id),
constraint uq_descuento_desembolso_nombre unique(nombre)
);

create table desembolso(
id int not null,
prestamo_id int not null,
fecha date not null,
constraint pk_desembolso primary key(id),
constraint fk_desembolso_prestamo_id foreign key(prestamo_id) references prestamo(id)
);

create table detalle_desembolso(
id int not null,
desembolso_id int not null,
tipo_desembolso_id int not null, 
monto numeric not null, 
ahorro_id int,
cheque_id int,
constraint pk_detalle_desembolso primary key(id),
constraint fk_detalle_desembolso_tipo_desembolso_id foreign key(tipo_desembolso_id) references tipo_desembolso(id)
);

create table detalle_descuento(
id int not null,
desembolso_id int not null,
descuento_id int not null,
monto numeric not null,
constraint pk_detalle_descuento primary key(id),
constraint fk_detalle_descuento_desembolso_id foreign key(desembolso_id) references desembolso(id),
constraint fk_detalle_descuento_descuento_id foreign key(descuento_id) references descuento(id)
);

-- plan de pago (ideal)
create table plan_pago(
id int not null,
cuenta_id int not null, -- 12548
monto_capital numeric not null, -- 100
interes numeric not null, -- 10
saldo numeric, 
nro_cuota int,
fecha_vencimiento date not null,
constraint pk_cuota primary key(id),
constraint fk_cuota_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table cuota(
id int not null,
cuenta_id int not null, -- 12548
monto_capital numeric not null, -- 100
interes numeric not null, -- 10
interes_moratorio numeric, 
interes_punitorio numeric,
saldo numeric, 
nro_cuota int,
fecha_vencimiento date not null,
constraint pk_cuota primary key(id),
constraint fk_cuota_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table producto_credito(
id int not null,
nombre character varying(100) not null,
tipo_credito_id int not null, -- consumo
sub_tipo_id int not null, -- compra anteojos 
monto_hasta numeric not null, -- 5.000.000
relacion_aporte character varying(20) not null, -- 1/15
plazo_minimo int not null, -- 6
plazo_maximo int not null, -- 36
constraint pk_producto_credito primary key(id),
constraint fk_producto_credito_tipo_credito_id foreign key(tipo_credito_id) references tipo_credito(id),
constraint fk_producto_credito_sub_tipo_id foreign key(sub_tipo_id) references sub_tipo_credito(id)
);

create table producto_detalle(
id int not null,
producto_credito_id int not null,
cuota_desde int not null, -- 13   
cuota_hasta int not null, -- 16
tasa numeric not null, -- 18
constraint pk_producto_detalle primary key(id),
constraint fk_producto_detalle_producto_credito_id foreign key(tipo_credito_id) references tipo_credito(id),
);


