-- mdulo de socio y admisin

create table pais(
id int not null,
nombre character varying(100) not null,
constraint pk_pais primary key(id),
constraint uq_pais_nombre unique(nombre)
);

create table ciudad(
id int not null,
nombre character varying(100) not null,
pais_id int not null,
constraint pk_ciudad primary key(id),
constraint fk_ciudad_pais_id foreign key(pais_id) references pais
);

create table barrio(
id int not null,
nombre character varying(100) not null,
ciudad_id int not null,
constraint pk_barrio primary key(id),
constraint fk_barrio_ciudad_id foreign key(ciudad_id) references ciudad(id)
);

-- casa propia, alquilada, otros
create table tipo_casa(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_casa primary key(id),
constraint uq_tipo_casa_nombre unique(nombre)
);

create table actividad_economica(
id int not null,
nombre character varying(100) not null,
constraint pk_actividad_economica primary key(id),
constraint uq_actividad_economica_nombre unique(nombre)
);

create table nivel_academico(
id int not null,
nombre character varying(100) not null,
constraint pk_nivel_academico primary key(id),
constraint uq_nivel_academico_nombre unique(nombre)
);

create table estado_civil(
id int not null,
nombre character varying(100) not null,
constraint pk_estado_civil primary key(id),
constraint uq_estado_civil_nombre unique(nombre)
);

create table profesion(
id int not null,
nombre character varying(100) not null,
constraint pk_profesion primary key(id),
constraint uq_profesion_nombre unique(nombre)
);
-- entidad para cargo publico
create table entidad(
id int not null,
nombre character varying(100) not null,
constraint pk_entidad primary key(id),
constraint uq_entidad_nombre unique(nombre)
);

create table cargo(
id int not null,
nombre character varying(100) not null,
constraint pk_cargo primary key(id),
constraint uq_cargo_nombre unique(nombre)
);

create table tipo_sociedad(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_sociedad primary key(id),
constraint uq_tipo_sociedad_nombre unique(nombre)
);

create table tipo_parentesco(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_parentesco primary key(id),
constraint uq_tipo_parentesco_nombre unique(nombre)
);

-- asalariado, informal, jubilado
create table tipo_ingreso(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_ingreso primary key(id),
constraint uq_tipo_ingreso_nombre unique(nombre)
);

create table estado_socio(
id int not null,
nombre character varying(100) not null,
constraint pk_estado_socio primary key(id),
constraint uq_estado_socio_nombre unique(nombre)
);

create table estado(
id int not null,
nombre character varying(100) not null,
constraint pk_estado primary key(id),
constraint uq_estado unique(nombre)
);

-- ci, ruc, pasaporte
create table tipo_documento(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_documento primary key(id),
constraint uq_tipo_documento_nombre unique(nombre)
);

create table persona(
id int not null,
nombres_razon_social character varying(100) not null,
apellidos character varying(100) not null,
tipo_persona char(1) not null,
documento_ruc character varying(50) not null,
tipo_documento_id int not null,
fecha_nacimiento_constitucion date not null,
constraint pk_persona primary key(id),
constraint ck_persona check ((tipo_persona = ANY (ARRAY['F'::bpchar, 'J'::bpchar]))),
constraint fk_persona_tipo_documento_id foreign key(tipo_documento_id) references tipo_documento(id)
);

create table socio(
id int not null,
persona_id int not null,
tipo_persona char(1) not null,
socio_nro character varying(100) not null,
fecha_nacimiento_constitucion date not null,
direccion character varying(200) not null,
barrio_id int not null,
telefonos character varying(50),
celular character varying(50),
correo_electronico character varying(50),
pais_id int not null,
tipo_ingreso_id int not null,
estado_socio_id int not null,
constraint pk_socio primary key(id),
constraint fk_socio_persona_id foreign key(persona_id) references persona(id),
constraint ck_socio check ((tipo_persona = ANY (ARRAY['F'::bpchar, 'J'::bpchar]))),
constraint fk_socio_estado_socio_id foreign key(estado_socio_id) references estado_socio(id),
constraint fk_socio_barrio_id foreign key(barrio_id) references barrio(id),
constraint fk_socio_tipo_ingreso_id foreign key(tipo_ingreso_id) references tipo_ingreso(id),
constraint fk_socio_pais_id foreign key(pais_id) references pais(id)
);

create table socio_fisico(
id int not null,
socio_id int not null,
es_funcionario boolean not null,
es_directivo boolean not null,
extranjero boolean not null,
cant_personas_cargo int, 
separacion_bienes boolean not null,
grupo_sanguineo character varying(20),
ciudad_nacimiento_id int not null,
nivel_academico_id int not null,
profesion_id int not null,
nro_carnet_admision character varying(20),
estado_civil_id int not null,
constraint pk_socio_fisico primary key(id),
constraint fk_socio_fisico_socio_id foreign key(socio_id) references socio(id),
constraint fk_socio_fisico_nivel_academico_id foreign key(nivel_academico_id) references nivel_academico(id),
constraint fk_socio_fisico_profesion_id foreign key(profesion_id) references profesion(id),
constraint fk_socio_fisico_ciudad_nacimiento_id foreign key(ciudad_nacimiento_id) references ciudad(id),
constraint fk_socio_fisico_estado_civil_id foreign key(estado_civil_id) references estado_civil(id)
);

create table socio_fisico_domicilio(
id int not null,
socio_fisico_id int not null,
direccion character varying(200) not null,
tipo_casa_id int not null,
barrio_id int not null,
valor_casa numeric,
nro_domicilio character varying(20),
constraint pk_socio_fisico_domicilio primary key(id),
constraint fk_socio_fisico_domicilio_socio_fisico__id foreign key(socio_fisico_id) references socio_fisico(id),
constraint fk_socio_fisico_domicilio_tipo_casa_id foreign key(tipo_casa_id) references tipo_casa(id),
constraint fk_socio_fisico_domicilio_barrio_id foreign key(barrio_id) references barrio(id)
);

create table socio_fisico_laboral(
id int not null,
socio_fisico_id int not null,
direccion_laboral character varying(200),
barrio_id int not null,
entidad_id int not null,
telefono character varying(50),
antiguedad character varying(50),
correo character varying(50),
activdad_economica_id int not null,
actividad_laboral character varying(100),
constraint pk_socio_fisico_laboral primary key(id),
constraint fk_socio_fisico_laboral_socio_fisico__id foreign key(socio_fisico_id) references socio_fisico(id),
constraint fk_socio_fisico_laboral_entidad_id foreign key(entidad_id) references entidad(id),
constraint fk_socio_fisico_laboral_barrio_id foreign key(barrio_id) references barrio(id),
constraint fk_socio_fisico_laboral_economica_id foreign key(activdad_economica_id) references actividad_economica(id)
);

create table persona_expuesta(
id int not null,
socio_fisico_id int not null,
cargo_laboral_id int not null, 
cargo_publico boolean not null, 
entidad_cargo_publico_id int, 
periodo_inicio int, 
periodo_fin int,
es_conyuge_pariente boolean not null,
es_accionista_asociado boolean not null,
miembro_gerencia_organizacion boolean not null,
es_proveedor_estado boolean not null,
registro_informacion_proveedores boolean not null,
obs character varying,
constraint pk_persona_expuesta primary key(id),
constraint fk_persona_expuesta_socio_fisico_id foreign key(socio_fisico_id) references socio_fisico(id),
constraint fk_persona_expuesta_cargo_laboral_id foreign key(cargo_laboral_id) references cargo(id),
constraint fk_persona_expuesta_entidad_cargo_publico_id foreign key(entidad_cargo_publico_id) references entidad(id)
);

create table socio_juridico(
id int not null,
socio_id int not null,
pais_residencia_id int not null,
actividad_economica_id int not null,
proposito_relacion character varying(100) not null,
tipo_sociedad_id int not null,
tipo_sociedad_otro character varying(100),
cant_sucursales int, 
cant_empleados int,
url_web character varying(100),
constraint pk_socio_juridico primary key(id),
constraint fk_socio_juridico_socio_id foreign key(socio_id) references socio(id),
constraint fk_socio_juridico_pais_residencia_id foreign key(pais_residencia_id) references pais(id),
constraint fk_socio_juridico_actividad_economica_id foreign key(actividad_economica_id) references actividad_economica(id),
constraint fk_socio_juridico_tipo_sociedad_id foreign key(tipo_sociedad_id) references tipo_sociedad(id)
);

create table accionista(
id int not null,
socio_juridico_id int not null,
persona_id int not null,
cargo_id int not null,
duracion_mandato character varying(30) not null,
direccion_particular character varying(200) not null,
telefono character varying(50) not null,
constraint pk_accionista primary key(id),
constraint fk_accionista_socio_juridico_id foreign key(socio_juridico_id) references socio_juridico(id),
constraint fk_accionista_persona_id foreign key(persona_id) references persona(id),
constraint fk_accionista_cargo_id foreign key(cargo_id) references cargo(id)
);

create table parentesco(
id int not null,
socio_fisico_id int not null,
persona_id int not null,
tipo_parentesco_id int not null,
ciudad_nacimiento_id int not null,
direccion character varying(200),
telefono character varying(50),
correo character varying(60),
nivel_academico_id int,
profesion_id int,
entidad_laboral_id int,
direccion_laboral character varying(200),
barrio_laboral_id int,
telefono_laboral character varying(50),
cargo_laboral_id int,
constraint pk_parentesco primary key(id),
constraint fk_parentesco_persona_id foreign key(persona_id) references persona(id),
constraint fk_parentesco_socio_fisico_id foreign key(socio_fisico_id) references socio_fisico(id),
constraint fk_parentesco_tipo_parentesco_id foreign key(tipo_parentesco_id) references tipo_parentesco(id),
constraint fk_parentesco_ciudad_nacimiento_id foreign key(ciudad_nacimiento_id) references ciudad(id),
constraint fk_parentesco_nivel_academico_id foreign key(nivel_academico_id) references nivel_academico(id),
constraint fk_parentesco_profesion_id foreign key(profesion_id) references profesion(id),
constraint fk_parentesco_entidad_laboral_id foreign key(entidad_laboral_id) references entidad(id),
constraint fk_parentesco_barrio_laboral_id foreign key(barrio_laboral_id) references barrio(id),
constraint fk_parentesco_cargo_laboral_id foreign key(cargo_laboral_id) references cargo(id)
);

create table inmueble(
id int not null,
socio_id int not null,
ciudad_id int not null,
finca_nro character varying(50) not null,
hipotecado boolean not null,
edificado boolean not null,
valor_actual numeric not null,
cta_cte_catastral character varying(50) not null,
superficie_terreno numeric,
superficie_edificio numeric,
a_nombre_de character varying(100) not null,
url_google_maps character varying(200) not null,
latitud character varying(50),
longitud character varying(50),
constraint pk_inmueble primary key(id),
constraint fk_inmueble_socio_id foreign key(socio_id) references socio(id),
constraint fk_inmueble_ciudad_id foreign key(ciudad_id) references ciudad(id)
);

create table tipo_vehiculo(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_vehiculo primary key(id),
constraint uq_tipo_vehiculo unique(nombre));

create table marca(
id int not null,
nombre character varying(100) not null,
constraint pk_marca primary key(id),
constraint uq_marca unique(nombre));

create table rodado(
id int not null,
socio_id int not null,
tipo_vehiculo_id int not null,
marca_id int not null,
modelo character varying(50) not null,
ao_fabricacion int not null,
prendado boolean not null,
asegurado boolean not null,
valor_actual numeric not null,
constraint pk_rodado primary key(id),
constraint fk_rodado_socio_id foreign key(socio_id) references socio(id),
constraint fk_rodado_tipo_vehiculo_id foreign key(tipo_vehiculo_id) references tipo_vehiculo(id),
constraint fk_rodado_marca_id foreign key(marca_id) references marca(id)
);

create table cuentas_externas(
id int not null,
socio_id int not null,
entidad_financiera_id int not null,
porcentaje_participacion int,
nro_cuenta character varying(50) not null,
valor numeric not null,
modalidad character varying(50) not null,
vencimiento date,
constraint pk_cuentas_externas primary key(id),
constraint fk_cuentas_externas_socio_id foreign key(socio_id) references socio(id),
constraint fk_cuentas_externas_entidad_financiera_id foreign key(entidad_financiera_id) references entidad(id));

create table otros_bienes(
id int not null,
socio_id int not null,
descripcion character varying(100) not null,
valor numeric not null,
constraint pk_otros_bienes primary key(id),
constraint fk_otros_bienes_socio_id foreign key(socio_id) references socio(id)
);

create table deudas_externas(
id int not null,
socio_id int not null,
entidad_financiera_id int not null,
vencimiento date,
nro_cuota int,
garanta numeric,
deuda_inicial numeric,
saldo numeric,
constraint pk_deudas_externas primary key(id),
constraint fk_deudas_externas_socio_id foreign key(socio_id) references socio(id),
constraint fk_deudas_externas_entidad_financiera_id foreign key(entidad_financiera_id) references entidad(id)
);

create table referencias(
id int not null,
socio_id int not null,
nombre_completo character varying(100) not null,
telefono character varying(50) not null,
entidad_id int not null,
constraint pk_referencias primary key(id),
constraint fk_referencias_socio_id foreign key(socio_id) references socio(id),
constraint fk_referencias_entidad_id foreign key(entidad_id) references entidad(id)
);

create table deudas_hipotecarias(
id int not null,
socio_id int not null,
nombre_apellido_acreedor character varying(500) not null,
objeto_prendario character varying(50) not null,
vencimiento date, 
importe_deuda numeric,
constraint pk_deudas_hipotecarias primary key(id),
constraint fk_deudas_hipotecarias_socio_id foreign key(socio_id) references socio(id)
);

create table concepto_renta(
id int not null,
nombre character varying(100) not null,
egreso boolean not null,
constraint pk_concepto_renta primary key(id),
constraint uq_concepto_renta_nombre unique(nombre)
);

create table renta_mensual(
id int not null,
socio_id int not null,
concepto_renta_id int not null,
importe numeric not null,
constraint pk_renta_mensual primary key(id),
constraint fk_renta_mensual_socio_id foreign key(socio_id) references socio(id),
constraint fk_renta_mensual_concepto_renta_id foreign key(concepto_renta_id) references concepto_renta(id)
);

create table socio_historico(
id int not null,
socio_id int not null,
fecha_evento date not null,
nro_socio character varying(50),
estado_socio_id int not null,
obs character varying(50),
constraint pk_socio_historico primary key(id),
constraint fk_socio_historico_socio_id foreign key(socio_id) references socio(id),
constraint fk_socio_historico_estado_socio_id foreign key(estado_socio_id) references estado_socio(id)
);

create table solicitud(
id int not null,
fecha_solicitud date not null,
nro_solicitud character varying(20) not null,
fecha_sesion date,
acta_nro character varying(50),
sesion character varying(50),
observacion character varying(200),
persona_id int not null,
nombre_pariente_proximo character varying(100),
telefono_pariente_proximo character varying(50),
telefono_vecino_proximo character varying(50),
nombre_vecino_proximo character varying(100),
constraint pk_solicitud primary key(id),
constraint fk_solicitud_persona_id foreign key(persona_id) references persona(id)
);

create table tipo_archivo(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_archivo primary key(id),
constraint uq_tipo_archivo_nombre unique(nombre)
);

create table archivo(
id int not null,
fecha_subida date not null,
tipo_archivo_id int not null,
ruta character varying(200) not null,
nombre_archivo character varying(100) not null,
tipo_extension character varying(30) not null,
solicitud_id int,
constraint pk_archivo primary key(id),
constraint fk_archivo_tipo_archivo_id foreign key(tipo_archivo_id) references tipo_archivo(id),
constraint fk_archivo_solicitud_id foreign key(solicitud_id) references solicitud(id)
);

create table tipo_cuenta(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_cuenta primary key(id),
constraint uq_tipo_cuenta_nombre unique(nombre)
);

create table estado_cuenta(
id int not null,
nombre character varying(100) not null,
constraint pk_estado_cuenta primary key(id),
constraint uq_estado_cuenta_nombre unique(nombre)
);

create table titular_cuenta(
id int not null,
cuenta_id int not null,
socio_titular_id int not null,
co_titular_id int not null,
constraint pk_titular_cuenta primary key(id),
constraint fk_titular_cuenta_socio_titular_id foreign key(socio_titular_id) references socio(id),
constraint fk_titular_cuenta_co_titular_id foreign key(co_titular_id) references persona(id),
constraint fk_titular_cuenta_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

-- se preve sucursal?
create table cuenta(
id int not null,
socio_id int not null, --titular de cuenta
fecha_apertura date not null,
fecha_expiracion date,
solicitud_id int,
saldo numeric,
saldo_promedio numeric,
saldo_contable numeric,
saldo_bloqueado numeric,
saldo_retenido numeric,
dias_atraso int,
maximo_atraso int,
monto_atraso numeric,
motivo_cancelacion character varying(100) not null,
fecha_cancelacion date,
fecha_ultimo_movimiento date,
estado_cuenta_id int not null,
tipo_cuenta_id int not null,
constraint pk_cuenta primary key(id),
constraint fk_cuenta_socio_id foreign key(socio_id) references socio(id),
constraint fk_cuenta_solicitud_id foreign key(solicitud_id) references solicitud(id),
constraint fk_cuenta_estado_cuenta_id foreign key(estado_cuenta_id) references estado_cuenta(id),
constraint fk_cuenta_tipo_cuenta_id foreign key(tipo_cuenta_id) references tipo_cuenta(id)
);

create table cuenta_socio(
id int not null,
persona_id int not null,
cuenta_id int not null,
es_titular boolean not null,
constraint pk_cuenta_socio primary key(id),
constraint fk_cuenta_estado_persona_id foreign key(persona_id) references persona(id),
constraint fk_cuenta_estado_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table aporte(
id int not null,
cuenta_id int not null,
nro_cuota int not null,
monto_pagar numeric not null,
vencimiento date not null,
pagado numeric,
descuento numeric,
saldo numeric,
constraint pk_aporte primary key(id),
constraint fk_aporte_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table solidaridad(
id int not null,
cuenta_id int not null,
nro_cuota int not null,
monto_pagar numeric not null,
vencimiento date not null,
pagado numeric,
descuento numeric,
saldo numeric,
constraint pk_solidaridad primary key(id),
constraint fk_solidaridad_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

-- persona, indistina, 
create table tipo_ahorro(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_ahorro primary key(id),
constraint uq_tipo_ahorro_nombre unique(nombre)
);

-- a la vista, plazo fijo, etc 
create table modalidad(
id int not null,
nombre character varying(100) not null,
constraint pk_modalidad primary key(id),
constraint uq_modalidad_nombre unique(nombre)
);

create table solicitud_ahorro(
id int not null,
tipo_ahorro_id int not null,
fecha date not null,
modalidad_id int not null,
socio_id int not null,
monto_solicitado numeric,
estado_id int not null,
constraint pk_solicitud_ahorro primary key(id),
constraint fk_solicitud_ahorro_tipo_ahorro_id foreign key(tipo_ahorro_id) references tipo_ahorro(id),
constraint fk_solicitud_ahorro_modalidad_id foreign key(modalidad_id) references modalidad(id),
constraint fk_solicitud_ahorro_socio_id foreign key(socio_id) references socio(id),
constraint fk_solicitud_estado_id foreign key(estado_id) references estado(id)
);

create table ahorro(
id int not null,
cuenta_id int not null,
tipo_cuenta_id int not null,
modalidad_id int not null,
total_inversion numeric not null,
total_interes numeric not null,
saldo numeric,
plazo int not null,
tasa int not null,
forma_pago varying(20), 
hecho_por varying(20),
verificado_por varying(20),
visto_bueno_por varying(20),
contrato_nro varying(20),
proforma_nro varying(20),
constraint pk_ahorro primary key(id),
constraint fk_ahorro_cuenta_id foreign key(cuenta_id) references cuenta(id),
constraint fk_ahorro_tipo_cuenta_id foreign key(tipo_cuenta_id) references tipo_cuenta(id),
constraint fk_ahorro_modalidad_id foreign key(modalidad_id) references modalidad(id)
);

create table liquidacion_ahorro(
id int not null,
ahorro_id int not null,
nro_cuota int,
fecha_vencimiento date not null,
monto_capital numeric not null,
monto_interes numeric not null,
constraint pk_liquidacion_ahorro primary key(id),
constraint fk_liquidacion_ahorro_ahorro_id foreign key(ahorro_id) references ahorro(id)
);

-- efectivo, otros banco, cheque
create table tipo_deposito(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_deposito primary key(id),
constraint uq_tipo_deposito_nombre unique(nombre)
);

-- bancos para cheques
create table institucion_financiera(
id int not null,
nombre character varying(100) not null,
constraint pk_institucion_financiera primary key(id),
constraint uq_institucion_financiera_nombre unique(nombre)
);

-- extraccin/deposito/interes
create table movimiento_ahorro(
id int not null,
ahorro_id int not null,
tipo char(3) not null, -- EXT/DEP/INT
fecha date not null,
depositado_por character varying(100) not null,
extraido_por character varying(100) not null,
monto numeric not null,
saldo numeric,
nro_boleta character varying(50),
constraint pk_comprobante primary key(id),
constraint fk_comprobante_ahorro_id foreign key(ahorro_id) references ahorro(id)
);

create table movimiento_ahorro_tipo_deposito(
id int not null,
movimiento_ahorro_id int not null,
monto_depositado numeric not null,
tipo_deposito_id int not null,
institucion_financiera_id int,
cheque_nro character varying(50) not null,
constraint pk_movimiento_ahorro_tipo_deposito primary key(id),
constraint fk_movimiento_ahorro_tipo_deposito_tipo_deposito_id foreign key(tipo_deposito_id) references tipo_deposito(id),
constraint fk_movimiento_ahorro_tipo_deposito_movimiento_ahorro_id foreign key(movimiento_ahorro_id) references movimiento_ahorro(id),
constraint fk_comprobante_tipo_deposito_institucion_financiera_id foreign key(institucion_financiera_id) references institucion_financiera(id),
);

create table tarjeta_debito(
id int not null,
nro_tarjeta character varying(100) not null,
marca_id int, --visa/ mastercard
cuenta_id int not null,
vencimiento date not null
estado_tarjeta int,
constraint pk_tarjeta primary key(id),
constraint fk_tarjeta_cuenta_id foreign key(cuenta_id) references ahorro(id)
);

create table tipo_transaccion(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_transaccion primary key(id),
constraint uq_tipo_transaccion_nombre unique(nombre)
);

create table transaccion(
id int not null,
fecha date not null,
tipo_transaccion_id int not null,
nro_comprobante character varying(50) not null,
cuenta_id int not null,
total_transaccion numeric,
constraint pk_transaccion primary key(id),
constraint fk_transaccion_cuenta_id foreign key(cuenta_id) references cuenta(id),
constraint fk_transaccion_tipo_transaccion_id foreign key(tipo_transaccion_id) references tipo_transaccion(id)
);

create table cobro(
id int not null,
transaccion_id int not null,
monto_cobrado numeric,
constraint pk_cobro primary key(id),
constraint fk_cobro_transaccion_id foreign key(transaccion_id) references transaccion(id)
);


-- mdulo prstamos

create table tipo_archivo(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_archivo primary key(id),
constraint uq_tipo_archivo_nombre unique(nombre)
);

create table estado(
id int not null,
nombre character varying(100) not null,
constraint pk_estado primary key(id),
constraint uq_estado_nombre unique(nombre)
);

create table destino(
id int not null,
nombre character varying(100) not null,
constraint pk_destino primary key(id),
constraint uq_destino_nombre unique(nombre)
);

create table tipo_garantia(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_garantia primary key(id),
constraint uq_tipo_garantia_nombre unique(nombre)
);

create table tipo_plazo(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_plazo primary key(id),
constraint uq_tipo_plazo_nombre unique(nombre)
);

create table archivo_solicitud(
id int not null,
archivo_id int not null,
solicitud_id int not null,
constraint pk_archivo_solicitud primary key(id),
constraint fk_archivo_solicitud_archivo_id foreign key(archivo_id) references archivo(id),
constraint fk_archivo_solicitud_solicitud_id foreign key(solicitud_id) references solicitud(id)
);

create table archivo(
id int not null,
fecha_subida date not null,
tipo_archivo_id int not null,
ruta character varying(200) not null,
nombre_archivo character varying(100) not null,
tipo_extension character varying(30) not null,
solicitud_id int,
constraint pk_archivo primary key(id),
constraint fk_archivo_tipo_archivo_id foreign key(tipo_archivo_id) references tipo_archivo(id),
constraint fk_archivo_solicitud_id foreign key(solicitud_id) references solicitud(id)
);

create table cuenta(
id int not null,
socio_id int not null, --titular de cuenta
fecha_apertura date not null,
fecha_expiracion date,
solicitud_id int,
saldo numeric,
saldo_promedio numeric,
saldo_contable numeric,
saldo_bloqueado numeric,
saldo_retenido numeric,
dias_atraso int,
maximo_atraso int,
monto_atraso numeric,
motivo_cancelacion character varying(100) not null,
fecha_cancelacion date,
fecha_ultimo_movimiento date,
estado_cuenta_id int not null,
tipo_cuenta_id int not null,
constraint pk_cuenta primary key(id),
constraint fk_cuenta_socio_id foreign key(socio_id) references socio(id),
constraint fk_cuenta_solicitud_id foreign key(solicitud_id) references solicitud(id),
constraint fk_cuenta_estado_cuenta_id foreign key(estado_cuenta_id) references estado_cuenta(id),
constraint fk_cuenta_tipo_cuenta_id foreign key(tipo_cuenta_id) references tipo_cuenta(id)
);

create table cuenta_socio(
id int not null,
persona_id int not null,
cuenta_id int not null,
es_titular boolean not null,
constraint pk_cuenta_socio primary key(id),
constraint fk_cuenta_estado_persona_id foreign key(persona_id) references persona(id),
constraint fk_cuenta_estado_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table perfil_economico(
id int not null,
fecha date not null,
persona_id int not null,
inmueble_id int not null,
rodado_id int not null,
cuentas_externas_id int not null,
otros_bienes_id int not null,
deudas_externas_id int not null,
deudas_hipotecarias_id int not null,
renta_mensual_id int not null,
constraint pk_perfil_economico primary key(id),
constraint fk_perfil_economico_persona_id foreign key(persona_id) references persona(id),
constraint fk_perfil_economico_inmueble_id foreign key(inmueble_id) references inmueble(id),
constraint fk_perfil_economico_rodado_id foreign key(rodado_id) references rodado(id),
constraint fk_perfil_economico_cuentas_externas_id foreign key(cuentas_externas_id) references cuentas_externas(id),
constraint fk_perfil_economico_otros_bienes_id foreign key(otros_bienes_id) references otros_bienes(id),
constraint fk_perfil_economico_deudas_externas_id foreign key(deudas_externas_id) references deudas_externas(id),
constraint fk_perfil_economico_deudas_hipotecarias_id foreign key(deudas_hipotecarias_id) references deudas_hipotecarias(id),
constraint fk_perfil_economico_renta_mensual_id foreign key(renta_mensual_id) references renta_mensual(id)
);

-- individual, intercooperativo, empleados
create table tipo_sujeto_credito(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_sujeto_credito primary key(id),
constraint uq_tipo_sujeto_credito_nombre unique(nombre)
);

-- normal, tarjeta crdito, vivienda
create table tipo_credito(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_credito primary key(id),
constraint uq_tipo_credito_nombre unique(nombre)
);

create table tipo_credito(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_credito primary key(id),
constraint uq_tipo_credito_nombre unique(nombre)
);

create table calificacion_socio(
id int not null,
socio_id int not null,
fecha date not null,
calificacion character varying(10) not null,
constraint pk_calificacion_socio primary key(id),
constraint fk_calificacion_socio_socio_id foreign key(socio_id) references socio(id)
);

create table solicitud_prorroga(
id int not null,
cuota_id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_prorroga primary key(id),
constraint fk_solicitud_prorroga_cuota_id foreign key(cuota_id) references cuota(id),
constraint fk_solicitud_prorroga_estado_id foreign key(estado_id) references estado(id)
);

create table solicitud_amplicacion(
id int not null,
prestamo_id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_amplicacion primary key(id),
constraint fk_solicitud_amplicacion_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_solicitud_amplicacion_estado_id foreign key(estado_id) references estado(id)
);

create table solicitud_refinanciacion(
id int not null,
prestamo_id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_amplicacion primary key(id),
constraint fk_solicitud_prorroga_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_solicitud_prorroga_estado_id foreign key(estado_id) references estado(id)
);

create table solicitud_consolidacion(
id int not null,
fecha_solicitud date not null,
motivo character varying(100) not null,
estado_solicitud_id int not null,
constraint pk_solicitud_amplicacion primary key(id),
constraint fk_solicitud_prorroga_estado_id foreign key(estado_id) references estado(id)
);

create table prestamo_consolidacion(
id int not null,
prestamo_id int not null,
solicitud_id int not null,
constraint pk_prestamo_consolidacion primary key(id),
constraint fk_prestamo_consolidacion_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_prestamo_consolidacion_solicitud_id foreign key(solicitud_id) references solicitud_consolidacion(id)
);

create table solicitud_prestamo(
id int not null,
socio_id int not null,
fecha_solicitud date not null,
nro_solicitud character varying(20) not null,
monto_solicitado numeric not null,
cant_cuotas int not null, 
observacion character varying(200),
perfil_economico_id int not null,
destino_id int not null,
tipo_credito_id int not null,
tipo_garantia_id int not null,
tipo_plazo_id int not null,
producto_credito_id int not null,
constraint pk_solicitud primary key(id),
constraint fk_solicitud_persona_id foreign key(persona_id) references persona(id)
);

create table analisis_credito(
id int not null,
solicitud_prestamo_id int not null,
analizado_por int not null, 
fecha_analisis date,
recomendacion_analista character varying(100),
jefe_por int not null, 
fecha_analisis_jefe date,
recomendacion_jefe character varying(100),
gerente_por int not null,
fecha_analisis_gerente date,
recomendacion_gerente character varying(100),
comite_por int not null, 
fecha_analisis_comite date,
recomendacion_comite character varying(100),
consejo_por int not null, 
fecha_analisis_consejo date,
recomendacion_consejo character varying(100),
estado_id int not null,
fecha_estado date not null,
constraint pk_analisis_credito primary key(id)
-- falta agregar los fks
);

create table prestamo(
id int not null,
cuenta_id int not null,
fecha_aprobacion date not null,
saldo numeric,
saldo_capital numeric,
saldo_interes numeric,
capital_pagado numeric,
interes_pagado numeric,
prevision numeric,
prevision_heredada numeric,
cantidad_cuotas int, 
monto_aprobado numeric, 
cantidad_cuotas_pagadas int,
producto_credito_id int not null,
constraint pk_prestamo primary key(id),
constraint fk_prestamo_cuenta_id foreign key(cuenta_id) references cuenta(id),
-- falta agregar los mismo
);

create table codeudor(
id int not null,
persona_id int not null,
prestamo_id int not null,
es_socio boolean not null,
es_conyuge boolean not null,
constraint pk_deudor primary key(id),
constraint fk_deudor_persona_id foreign key(persona_id) references persona(id),
constraint fk_deudor_prestamo_id foreign key(prestamo_id) references prestamo(id)
);

create table tipo_accion(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_accion primary key(id),
constraint uq_tipo_accion_nombre unique(nombre)
);

create table recuperacion(
id int not null,
prestamo_id int not null,
etapa int not null,
tipo_accion_id int not null,
tratamiento character varying(200) not null,
constraint pk_tipo_archivo primary key(id),
constraint fk_recuperacion_prestamo_id foreign key(prestamo_id) references prestamo(id),
constraint fk_recuperacion_tipo_accion_id foreign key(tipo_accion_id) references tipo_accion(id)
);

-- cheque, deposito ahorro
create table tipo_desembolso(
id int not null,
nombre character varying(100) not null,
constraint pk_tipo_desembolso primary key(id),
constraint uq_tipo_desembolso_nombre unique(nombre)
);

create table descuento_desembolso(
id int not null,
nombre character varying(100) not null,
constraint pk_descuento_desembolso primary key(id),
constraint uq_descuento_desembolso_nombre unique(nombre)
);

create table desembolso(
id int not null,
prestamo_id int not null,
fecha date not null,
constraint pk_desembolso primary key(id),
constraint fk_desembolso_prestamo_id foreign key(prestamo_id) references prestamo(id)
);

create table detalle_desembolso(
id int not null,
desembolso_id int not null,
tipo_desembolso_id int not null, 
monto numeric not null, 
ahorro_id int,
cheque_id int,
constraint pk_detalle_desembolso primary key(id),
constraint fk_detalle_desembolso_tipo_desembolso_id foreign key(tipo_desembolso_id) references tipo_desembolso(id)
);

create table detalle_descuento(
id int not null,
desembolso_id int not null,
descuento_id int not null,
monto numeric not null,
constraint pk_detalle_descuento primary key(id),
constraint fk_detalle_descuento_desembolso_id foreign key(desembolso_id) references desembolso(id),
constraint fk_detalle_descuento_descuento_id foreign key(descuento_id) references descuento(id)
);

-- plan de pago (ideal)
create table plan_pago(
id int not null,
cuenta_id int not null, -- 12548
monto_capital numeric not null, -- 100
interes numeric not null, -- 10
saldo numeric, 
nro_cuota int,
fecha_vencimiento date not null,
constraint pk_cuota primary key(id),
constraint fk_cuota_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table cuota(
id int not null,
cuenta_id int not null, -- 12548
monto_capital numeric not null, -- 100
interes numeric not null, -- 10
interes_moratorio numeric, 
interes_punitorio numeric,
saldo numeric, 
nro_cuota int,
fecha_vencimiento date not null,
constraint pk_cuota primary key(id),
constraint fk_cuota_cuenta_id foreign key(cuenta_id) references cuenta(id)
);

create table producto_credito(
id int not null,
nombre character varying(100) not null,
tipo_credito_id int not null, -- consumo
sub_tipo_id int not null, -- compra anteojos 
monto_hasta numeric not null, -- 5.000.000
relacion_aporte character varying(20) not null, -- 1/15
plazo_minimo int not null, -- 6
plazo_maximo int not null, -- 36
constraint pk_producto_credito primary key(id),
constraint fk_producto_credito_tipo_credito_id foreign key(tipo_credito_id) references tipo_credito(id),
constraint fk_producto_credito_sub_tipo_id foreign key(sub_tipo_id) references sub_tipo_credito(id)
);

create table producto_detalle(
id int not null,
producto_credito_id int not null,
cuota_desde int not null, -- 13   
cuota_hasta int not null, -- 16
tasa numeric not null, -- 18
constraint pk_producto_detalle primary key(id),
constraint fk_producto_detalle_producto_credito_id foreign key(tipo_credito_id) references tipo_credito(id),
);
